<?php $__env->startSection('title'); ?>
Default Setup
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Default Setup</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">All Default Setup</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<section class="content">
    <div class="container-fluid">
        <div class="row">

            <div class="col-lg-4 col-12">
                <form action="<?php echo e(route('admin.welcome-bonus.update',$wc_bonus->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Welcome Bonus</h3>
                        </div>
                        <div class="card-body row">
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="bonus">Bonus($)</label>
                                <input type="text" class="form-control" id="bonus" name="amount" value="<?php echo e($wc_bonus->amount); ?>" required placeholder="Bonus">
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-lg-4 col-12">
                <form action="<?php echo e(route('admin.dollar-rate.update',$dollar_rate->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Dollar Rate</h3>
                        </div>
                        <div class="card-body row">
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="rate">Rate(BDT)</label>
                                <input type="text" class="form-control" id="rate" name="rate" value="<?php echo e($dollar_rate->rate); ?>" required placeholder="Rate">
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-lg-4 col-12">
                <form action="<?php echo e(route('admin.job-fee.update',$jobFee->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Per Job Fee</h3>
                        </div>
                        <div class="card-body row">
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="fee">Fee(%)</label>
                                <input type="text" class="form-control" id="fee" name="fee" value="<?php echo e($jobFee->fee); ?>" required placeholder="Fee">
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-lg-4 col-12">
                <form action="<?php echo e(route('admin.withdraw-fee.update',$withdrawFee->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Balance Withdraw Setup</h3>
                        </div>
                        <div class="card-body row">
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="fee">Fee</label>
                                <input type="text" class="form-control" id="fee" name="fee" value="<?php echo e($withdrawFee->fee); ?>" required placeholder="Fee">
                            </div>
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="fee">Minimum($)</label>
                                <input type="text" class="form-control" id="minimum_withdraw" name="minimum_withdraw" value="<?php echo e($withdrawFee->minimum_withdraw); ?>" required placeholder="Minimum Withdraw">
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-lg-4 col-12">
                <form action="<?php echo e(route('admin.main-wallet.update',$main_wallet->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Admin Main Wallet</h3>
                        </div>
                        <div class="card-body row">
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="main_balance">Main Balance</label>
                                <input type="text" class="form-control" id="main_balance" name="main_balance" value="<?php echo e($main_wallet->amount); ?>" required placeholder="Main Balance">
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </div>
                </form>
            </div>
    
            <div class="col-lg-4 col-12">
                <form action="<?php echo e(route('admin.screenshot-charge.update',$schreen_shoot_charge->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Screenshoot Charge Setup</h3>
                        </div>
                        <div class="card-body row">
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="fee">Fee</label>
                                <input type="text" class="form-control" id="fee" name="fee" value="<?php echo e($schreen_shoot_charge->fee); ?>" required placeholder="Fee">
                            </div>
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="fee">Status</label>
                                <select class="form-control" name="status">
                                    <option value="1" <?php if($schreen_shoot_charge->status == 1): ?> selected <?php endif; ?>>Active</option>
                                    <option value="0" <?php if($schreen_shoot_charge->status == 0): ?> selected <?php endif; ?>>Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-success">Update</button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>

<script>
    $(function() {
        $("#example1").DataTable({
            "responsive": true
            , "autoWidth": false
        , });
        $('#example2').DataTable({
            "paging": true
            , "lengthChange": false
            , "searching": false
            , "ordering": true
            , "info": true
            , "autoWidth": false
            , "responsive": true
        , });
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sakibwe1/microjobtwo.sakibwebtech.website/resources/views/backend/pages/system-setting/deafult-setup.blade.php ENDPATH**/ ?>